%define module_name JS-SourceMap
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.2
Release: alt1
Summary: perl interface to JS sourcemaps
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AT/ATTILA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Current web development techniques like minification can make
debugging deployed JS code a pain.  Source maps are a compact
representation of the data necessary to turn a filename/line/column in
a JS runtime error thrown e.g. in your browser into the real
filename/line/column in the source code where the error occurred.

This is a set of Perl modules that allow you to decode and use JS
source maps.  A typical use case for this module is a server-side
component in Perl that receives JS runtime error information somehow
from a web application's JS front end.  You usually have the source
map available on the server already but there is a `discover` function
in `JS::SourceMap` that will search JS code for a pointer to its
source map as per convention.  You'll have to fetch the URL that
`discover` finds yourself, though.

We have adapted much of this Perl implementation from the Python
implementation at https://github.com/mattrobenolt/python-sourcemap,
which is BSD-licensed.  Our API is very similar to that Python
module's.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE
%perl_vendor_privlib/J*

%changelog
