# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(FileHandle.pm) perl(Module/Build.pm) perl(Test/More.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define module_version 0.29
%define module_name JS-Test-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.29
Release: alt1
Summary: Basic utilities for writing JavaScript tests.
Group: Development/Perl
License: artistic
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DW/DWHEELER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This is an extremely simple, extremely basic module for writing tests suitable
for JavaScript classes and other pursuits. If you wish to do more complicated
testing, use Test.More (a drop-in replacement for this one).

The basic unit of testing is the ok. For each thing you want to test your
program will print out an "ok" or "not ok" to indicate pass or fail. You do
this with the ok() function (see below).

The only other constraint is that you must pre-declare how many tests you
plan to run. This is in case something goes horribly wrong during the test and
your test program aborts, or skips a test or whatever. You do this like so:

  <script type="text/javascript">
    plan({ tests: 23 });
  </script>

You must have a plan.

=over

=item ok

  ok( foo == bar, description );
  ok( foo == bar );

ok() is given an expression (in this case `foo == bar'). If it's true, the
test passed. If it's false, it didn't. That's about it.

ok() prints out either "ok" or "not ok" along with a test number (it keeps
track of that for you).

  // This produces "ok 1 - Hell not yet frozen over" (or not ok)
  ok( getTemperature(hell) > 0, 'Hell not yet frozen over' );

If you provide a `description', that will be printed along with the "ok/not
ok" to make it easier to find your test when if fails (just search for the
name). It also makes it easier for the next guy to understand what your test
is for. It's highly recommended you use test names.

=back

Test.Simple will start by printing number of tests run in the form "1..M" (so
"1..5" means you're going to run 5 tests). This strange format lets
Test.Harness know how many tests you plan on running in case something goes
horribly wrong.

If all your tests passed, Test.Simple will exit with zero (which is normal). If
anything failed it will exit with how many failed. If you run less (or more)
tests than you planned, the missing (or extras) will be considered failures.
If no tests were ever run, Test.Simple will throw a warning and exit with 255.
If the test died, even after having successfully completed all its tests, it
will still be considered a failure and will exit with 255.

This module is by no means trying to be a complete testing system. It's just
to get you started. Once you're off the ground, we recommended that you look
at the Test.More manpage.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/J*

%changelog
