# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(MarpaX/Simple.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define module_version 0.02
%define module_name JSON-Decode-Marpa
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: JSON parser using Marpa
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/JSON-Decode-Marpa

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is based on the MarpaX::Demo::JSONParser manpage (using `json.2.bnf'), but
offers a more convenient interface for JSON decoding. I packaged this for casual
benchmarking against the Pegex::JSON manpage and the JSON::Decode::Regexp manpage.

The result on my computer: Pegex::JSON and JSON::Decode::Marpa are roughly the
same speed (but Pegex has a much smaller startup overhead than Marpa).
JSON::Decode::Regexp is about an order of magnitude faster than this module, and
JSON::XS is about *three orders of magnitude* faster. So that's that.

This is the benchmark code used:

 use 5.010;
 use strict;
 use warnings;

 use Benchmark qw(timethese);
 use JSON::Decode::Marpa ();
 use JSON::Decode::Regexp ();
 use JSON::XS ();
 use Pegex::JSON;

 my $json = q([1,"abc\ndef",-2.3,null,[],[1,2,3],{},{"a":1,"b":2}]);
 my $pgx  = Pegex::JSON->new;

 timethese -0.5, {
     pegex  => sub { $pgx->load($json) },
     regexp => sub { JSON::Decode::Regexp::from_json($json) },
     marpa  => sub { JSON::Decode::Marpa::from_json($json) },
     xs     => sub { JSON::XS::decode_json($json) },
 };
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/J*

%changelog
