# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(JSON/MaybeXS.pm) perl(PadWalker.pm) perl(Scalar/Util.pm) perl(Test/Fatal.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name JSON-Eval
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: eval Perl code found in JSON
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/JSON-Eval

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Perl data structures can contain several types of reference which do not have
a JSON equivalent. This module provides a technique for encoding and decoding
two of those reference types as JSON: coderefs and scalarrefs. (It also has
partial support for the Type::Tiny manpage objects.)

Coderefs must be self-contained, not closing over any variables. They will be
encoded as the following JSON:

  { "$eval": "sub { ... }" }

When decoding, any JSON object that contains a single key called "$eval" and
no other keys will be passed through eval to return the original coderef.
(Technically, when decoding, the Perl code being evaluated doesn't have to
return a coderef; it can return anything. This could allow for filehandles
or blessed objects, for example, to be decoded from JSON.)

Scalarrefs are encoded as:

  { "$scalar": ... }

So for example, the following JSON:

  { "foo": { "$scalar:" 42 } }

Will be decoded to this Perl structure:

  { 'foo' => \ 42 }

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README COPYRIGHT CREDITS LICENSE Changes
%perl_vendor_privlib/J*

%changelog
