# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(Fcntl.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/Pluggable.pm) perl(Net/FTP.pm) perl(Object/AUTHORITY.pm) perl(Parse/CPAN/Meta.pm) perl(Socket.pm) perl(Test/More.pm) perl(UNIVERSAL/ref.pm) perl(base.pm) perl(common/sense.pm) perl(inc/Module/Package.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define module_version 0.501
%define module_name JSON-JOM
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.501
Release: alt1
Summary: the JSON Object Model
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/JSON-JOM

Source0: http://cpan.org.ua/authors/id/T/TO/TOBYINK/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
JSON::JOM provides a DOM-like API for working with JSON..
While the JSON manpage represents JSON arrays as Perl arrayrefs and JSON objects as
Perl hashrefs, JSON::JOM represents each as a blessed object.

Internally, JSON::JOM::Object and JSON::JOM::Array store their data as a
hashref or arrayref, so you can still use this pattern of working:

  my $data = JSON::JOM::from_json(<<'JSON');
  {
    "foo": {
      "bar": [
        { "quux" : 0 },
        { "quux" : 1 },
        { "quux" : 2 },
      ]
    }
  }
  JSON
  
  foreach my $obj (@{ $data->{foo}{bar} })
  {
    printf("The quux of the matter is: %%d\n", $obj->{quux})
  }

But all arrays and objects provide various methods to make working with
them a bit easier. See the JSON::JOM::Object manpage and the JSON::JOM::Array manpage for
descriptions of these methods.

Values that the JSON module would represent as a Perl scalar, are
represented as a JSON::JOM::Value in JOM. This uses the overload manpage to
act like a scalar.

Note that if you use the arrayref/hashref way of working, things
are not always completely intuitive:

  $root  = to_jom({});
  $child = [ 1,2,3 ];
  
  # Add $child to our JOM structure:
  $root->{list} = $child;
  
  print $root->{list}->count . "\n";  # prints '3'
  
  # Now modify $child
  push @$child, 4;
  
  print $root->{list}->count . "\n";  # still '3'!

This is because the `$child' arrayref isn't just placed blindly into
the JOM structure, but "imported" into it. Compare the above with:

  $root  = to_jom({});
  $child = [ 1,2,3 ];
  
  # Add $child to our JOM structure, and this time,
  # set $child to point to the imported list.
  $child = $root->{list} = $child;
  
  print $root->{list}->count . "\n";  # prints '3'
  
  # Now modify $child
  push @$child, 4;
  
  print $root->{list}->count . "\n";  # prints '4'


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README examples
%perl_vendor_privlib/J*

%changelog
