%define module_name JSON-Karabiner
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Data/Dumper.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/HomeDir.pm) perl(JSON.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(parent.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.018
Release: alt1
Summary: easy JSON code generation for Karabiner-Elements
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/ST/STEVIED/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Karabiner stores rules for its modifications in a file using a data format
known as JSON which is painstaking to edit and create. JSON::Karbiner eases the
pain by letting Perl write the JSON for you. If you aren't familar with
Perl, or programming at all, don't worry. There are examples provided that you
can follow so no programming knowledge should be necessary. The 10 or 20 minutes
you spend learning how to install and use this module will pay off in spades.

A Karbiner JSON complex modification file stores the rules for modifying the keyboard
in a data structure called the "manipulators." Therefore, most of Perl code you
write adds data to the manipulator data structure. `JSON::Karabiner' can then
write the JSON to a file and then you can load the rules you've written using
the Kabrabiner-Elements program.

Below are descriptions of the methods you use to generate the json file.
There are three important methods to know:

=over 4

=item `add_action' method

for adding the from/to actions to the Karbiner manipulator data structure

=item `add_condition' method

for adding condtions to the manipulator structure

=item `add_parameters' method

for adding parameters to the manipulator data structure

=back

It will be very helpful if you have a basic familiarity with the Karbiner manipulator
definition. See the Karabiner complex_modification manipulator documentation for more information.

The documentation below is not exhaustive. You'll also need to consult the documentation at:

=over 4

=item from action

=item to action

=item conditions

=back

These pages document the methods for actions and conditions.

But the best way to learn, of course, is to experiment and see what happens.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/J*

%changelog
