%define module_name JSON-MultiValueOrdered
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Sub/Name.pm) perl(Test/More.pm) perl(base.pm) perl(if.pm) perl(overload.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: handle JSON like {"a":1, "a":2}
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/JSON-MultiValueOrdered

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOBYINK/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The JSON specification allows keys to be repeated within objects. It remains
silent on how repeated keys should be interpreted. Most JSON implementations
end up choosing just one of the values; sometimes the first, sometimes the
last.

JSON::MultiValueOrdered is a subclass of the JSON::Tiny manpage which treats objects as
ordered lists of key-value pairs, with duplicate keys allowed. It achieves this
by returning all hashes as tied using the Tie::Hash::MultiValueOrdered manpage. While
these hashes behave like standard Perl hashes (albeit while preserving the
original order of the keys), they provide a tied object interface allowing you
to retrieve additional values for each key.

JSON::MultiValueOrdered serialisation also serialises these additional values
and preserves order.

JSON::MultiValueOrdered is a subclass of the JSON::Tiny::Subclassable manpage and
the JSON::Tiny manpage, which is itself a fork of the Mojo::JSON manpage. Except where noted,
the methods listed below behave identically to the methods of the same names
in the superclasses.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE COPYRIGHT CREDITS README examples
%perl_vendor_privlib/J*
%perl_vendor_privlib/T*

%changelog
