Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-JSON-Pointer
Version:        0.07
Release:        alt2_25
Summary:        Perl implementation of JSON Pointer
License:        GPL+ or Artistic
URL:            https://metacpan.org/release/JSON-Pointer
Source0:        https://cpan.metacpan.org/authors/id/Z/ZI/ZIGOROU/JSON-Pointer-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(CPAN/Meta.pm)
BuildRequires:  perl(CPAN/Meta/Prereqs.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(B.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Class/Accessor/Lite.pm)
BuildRequires:  perl(Clone.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(JSON.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(URI/Escape.pm)
# Tests:
BuildRequires:  perl(Test/Exception.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(Carp.pm) >= 1.200
Requires:       perl(Class/Accessor/Lite.pm) >= 0.050
Requires:       perl(Clone.pm) >= 0.360
Requires:       perl(JSON.pm) >= 2.530
Requires:       perl(URI/Escape.pm) >= 3.310

# Filter under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(\(Carp\|Class.Accessor.Lite\|Clone\|JSON\|URI.Escape\).pm)/d

%description
This library is implemented JSON Pointer draft version 9
<http://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-09> and some
useful operators from JSON Patch draft version 10
<http://tools.ietf.org/html/draft-ietf-appsawg-json-patch-10>. JSON Pointer is
available to identify a specified value, and it is similar to XPath. Please
see the both of specifications for details.

%prep
%setup -q -n JSON-Pointer-%{version}
# Remove bundled modules
rm -rf inc/*
sed -i -e '/^inc\//d' MANIFEST

%build
perl Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%files
%doc --no-dereference LICENSE
%doc Changes README.md
%{perl_vendor_privlib}/*

%changelog
