# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(B.pm) perl(Benchmark.pm) perl(Encode.pm) perl(English.pm) perl(Exporter.pm) perl(File/Slurp.pm) perl(JSON.pm) perl(Scalar/Util.pm) perl(Test/Kwalitee.pm) perl(Test/Perl/Critic.pm) perl(overload.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: perl-Encode-JP
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    JSON-Tiny
%define upstream_version 0.58

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    Minimal JSON, no dependencies
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/JSON/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch:  noarch
Source44: import.info

%description
the JSON::Tiny manpage is a standalone adaptation of the Mojo::JSON
manpage, from the fabulous the Mojolicious manpage "web in a box" framework
(version 3.43). It has been adapted as a single-source-file module of about
345 lines of code with core-only dependencies.

Mojo::JSON was chosen as a starting point because it is so light-weight to
begin with, robust, relaxed, and well tested. Furthermore, Mojo::JSON's
tests were able to be adapted as easily as the module itself to a no
non-core dependency configuration.

Most of the remainder of this document is adapted directly from the
Mojo::JSON manpage. The names have been changed to protect the innocent.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README examples
%perl_vendor_privlib/*

%changelog
