%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(Carp.pm) perl(Config.pm) perl(Cwd.pm) perl(ExtUtils/MM_Unix.pm) perl(ExtUtils/MakeMaker.pm) perl(ExtUtils/Manifest.pm) perl(File/Basename.pm) perl(File/Find.pm) perl(File/Spec.pm) perl(FileHandle.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Moose/Role.pm) perl(Moose/Util/TypeConstraints.pm) perl(MooseX/Params/Validate.pm) perl(MooseX/Types.pm) perl(MooseX/Types/Moose.pm) perl(MooseX/Types/Structured.pm) perl(Net/FTP.pm) perl(Socket.pm) perl(Test/More.pm) perl(YAML/Tiny.pm) perl(inc/Module/Install.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name JavaScript-Framework-jQuery
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Generate markup and code for jQuery JavaScript framework
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/C/CO/CONVERTER/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Manage composition and insertion of `link' and `script' elements and the
jQuery `ready' call into generated HTML. 

Plugin modules provide support for individual jQuery plugins.

Framework plugins verify that the correct number of arguments will be passed to
JavaScript plugin constructors but perform no validation beyond
that.

This module provides four methods for inserting content into an HTML (or XHTML)
document:

=over

=item link_elements( )

For the mcDropdown plugin, for example, would print the LINK elements for the
jQueryUI and mcDropdown stylesheets. The output from this method should be
inserted in the HEAD element of the document:

 <link type="text/css" href="ui.all.css" rel="stylesheet" media="screen" />
 <link type="text/css" href="jquery.mcdropdown.css" rel="stylesheet" media="all" />

=item script_src_elements( )

Prints all the SCRIPT elements with SRC attribute. The output from this method
should be inserted in the HEAD element or somewhere before any calls to
code in the JavaScript files:

 <script type="text/javascript" src="jquery.min.js" />
 <script type="text/javascript" src="jquery.mcdropdown.js" />
 <script type="text/javascript" src="jquery.bgiframe.js" />

=item document_ready( )

Prints the jQuery $.ready function call and deletes any plugin objects created
in this response cycle from the queue (otherwise they would accumulate with
each request).

 <![CDATA[
 $(document).ready(function (){
 $("#inputid").mcDropdown("#ulid");
 });
 ]]>

Set transient_plugins to 0 if you wish to be able to fetch script and link
elements and $.ready function calls more than once.

=item constructor_calls( )

Returns only the text of the constructor calls for insertion into existing
code text. Useful for including the constructor calls in a template.

Set transient_plugins to 0 if you wish to be able to fetch script and link
elements and $.ready function calls more than once.

=back

Other accessors:

=over

=item transient_plugins( )

Set or get the value of transient_plugins. Takes 1 or 0.

=back

The data structure passed to the constructor provides the module with locations
for all the script and style assets required to make the jQuery plugins work.

The 'src' and 'css' buckets can contain multiple list items.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes.bak Changes README examples
%perl_vendor_privlib/J*

%changelog
