Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Filter/Util/Call.pm) perl(JavaScript/V8x/TestMoreish.pm) perl(LWP/Simple.pm) perl(Test/Deep.pm) perl(Text/Diff.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global cpan_version 0.30

Name:       perl-Jemplate 
# Keep 3-digit version for history
Version:    %{cpan_version}0
Release:    alt2_27
# lib/Jemplate.pm -> GPL+ or Artistic
# lib/Jemplate/Directive.pm -> GPL+ or Artistic
# lib/Jemplate/Parser.pm -> GPL+ or Artistic
# lib/Jemplate/Runtime.pm -> GPL+ or Artistic
# lib/Jemplate/Runtime/Compact.pm -> GPL+ or Artistic
License:    GPL-1.0-or-later OR Artistic-1.0-Perl
Summary:    JavaScript Templating with Template Toolkit 
Source:     https://cpan.metacpan.org/authors/id/I/IN/INGY/Jemplate-%{cpan_version}.tar.gz
# Do not prune INC, CPAN RT#87546
Patch0:     Jemplate-0.27-Do-not-prune-INC.patch
Url:        https://metacpan.org/release/Jemplate
BuildArch:  noarch

BuildRequires: perl-devel
BuildRequires: rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(strict.pm)
# Run-time:
BuildRequires: perl(base.pm)
BuildRequires: perl(bytes.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Config.pm)
BuildRequires: perl(constant.pm)
BuildRequires: perl(Encode.pm)
BuildRequires: perl(Exporter.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Find.pm)
# File::Find::Rule is bundled
BuildRequires: perl(File/Find/Rule.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(FindBin.pm)
BuildRequires: perl(Getopt/Long.pm)
# Number::Compare is bundled
BuildRequires: perl(overload.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Template.pm)
# Template is bundled
# Template::Base is bundled
# Template::Config is bundled
# Template::Constants is bundled
# Template::Directive is bundled
# Template::Document is bundled
# Template::Exception is bundled
# Template::Grammar is bundled
# Template::Parser is bundled
# Template::Provider is bundled
# Template::Service is bundled
# Template::TieString is bundled
# Text::Glob is bundled
BuildRequires: perl(vars.pm)
BuildRequires: perl(warnings.pm)
# Tests
BuildRequires: perl(HTTP/Daemon.pm)
BuildRequires: perl(HTTP/Response.pm)
BuildRequires: perl(HTTP/Status.pm)
BuildRequires: perl(IO/All.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(lib.pm)
BuildRequires: perl(LWP/MediaTypes.pm)
BuildRequires: perl(Path/Class.pm)
BuildRequires: perl(Pod/Usage.pm)
BuildRequires: perl(Test/Base.pm)
BuildRequires: perl(Test/Base/Filter.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(YAML.pm)
# Optional tests
#BuildRequires: perl(JavaScript::V8x::TestMoreish)

Requires:   perl(File/Find/Rule.pm) >= 0.330
Source44: import.info

%description
Jemplate is a templating framework for JavaScript that is built over
Perl's Template Toolkit (TT2). Jemplate parses TT2 templates using the
TT2 Perl framework, but with a twist. Instead of compiling the templates
into Perl code, it compiles them into JavaScript. Jemplate then provides
a JavaScript run-time module for processing the template code. Presto, we
have full featured JavaScript templating language!

%prep
%setup -q -n Jemplate-%{cpan_version}
%patch0 -p1
rm -rf inc
sed -i -e '/^inc\//d' MANIFEST

cat doc/text/Jemplate.text | iconv -f iso-8859-1 -t utf-8 > foo
cat foo > doc/text/Jemplate.text
rm foo

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
# %{_fixperms} %{buildroot}/*

%check
make test

%files
%doc Changes LICENSE README doc/ examples/ 
%{perl_vendor_privlib}/*
%{_bindir}/jemplate
%{_mandir}/man1/jemplate.1*

%changelog
