# BEGIN SourceDeps(oneline):
BuildRequires: libjudy-devel libsowing-devel perl(Alien/Judy.pm) perl(Config.pm) perl(DynaLoader.pm) perl(ExtUtils/CBuilder.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/Spec.pm) perl(Module/Build.pm) perl(Sub/Exporter.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(constant.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Judy
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.41
Release: alt4
Summary: Library for creating and accessing dynamic arrays
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JJ/JJORE/%{module_name}-%{version}.tar.gz

%description
The Judy family of functions supports fully dynamic arrays. These
arrays may be indexed by a 32- or 64-bit word (depending on processor
word size) (the Judy::1 manpage, the Judy::L manpage), a null terminated string
(the Judy::SL manpage), or an ordinary perl string (the Judy::HS manpage).

Judy arrays are both speed- and memory-efficient, with no tuning or
configuration required, across a wide range of key set types
(sequential, periodic, clustered, random). Judy's speed and memory
usage are typically better than other data storage models such as
skiplists, linked lists, binary, ternary, b-trees, or even hashing,
and improves with very large data sets.

The memory used by a Judy array is nearly proportional to the
population (number of elements).

Since an initial (empty) Judy array is represented by a null pointer,
it is possible to construct an array of Judy arrays. In other words, a
Judy array's Values can be pointers to other Judy arrays. This makes
it very simple to construct an array with an arbitrary number of
dimensions or Index sizes.

The libJudy author believes JudyHS is a good replacement for a hashing
method when resizing the hash table is done during population
growth. A correctly tuned hash method with a static hash table size
and population is unbeatable for speed. However, the Judy::HS manpage will
perform better than a hashing method with smaller and larger
populations than the optimum hash table size. JudyHS does not have a
degenerate performance case where knowledge of the hash algorithm can
be exploited. (I.E. JudyHS does not use a linked list to handle hash
collisions, it uses a tree of JudyL arrays and a virtual hash table
size of 4 billion).

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_archlib/J*
%perl_vendor_autolib/*

%changelog
