%define module_name LCS-Similar
# BEGIN SourceDeps(oneline):
BuildRequires: perl(LCS.pm) perl(Module/Build/Tiny.pm) perl(Test/Deep.pm) perl(Test/More.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt1
Summary: allow differences in the compared elements of Longest Common Subsequence (LCS) Algorithm
Group: Development/Perl
License: perl
URL: https://github.com/wollmers/LCS-Similar

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/W/WO/WOLLMERS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Pure LCS algorithms can be used for global alignment of two sequencies.

Usually they provide one result, but there can be more than one solution
fulfilling the criterion of being longest.

For example this two sequencies have two possible LCS:

   # solution1
   @sequence1 = qw/a b   d   /;
   @sequence2 = qw/  b a d c /;
   @lcs1      = qw/  b   d   /;

   # solution2
   @sequence1 = qw/  a b d   /;
   @sequence2 = qw/b a   d c /;
   @lcs2      = qw/  a   d   /;

Or an example of mistyping:

   eo___nnnnnicaio
    |   |    ||| |
   commun____icato

This is an actual result of a pure LCS algorithm. Here the letter n
of the second line could align in 5 possible ways with one of the letters n
of the first line, and the LCS will always have a length of 6.

But this solution better maps the mismatches:

   eonnnnnicaio
   ~|~~~ ||||~|
   commu_nicato

Here the tilde ~ represents similarity of the aligned characters.

With a function returning e.g. a similarity of 0.7 for a comparison of
similar characters this module takes similarity into account for alignment.

See examples.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/L*

%changelog
