%define module_name LWP-Protocol-rsync
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/RsyncP.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(HTTP/Date.pm) perl(HTTP/Response.pm) perl(HTTP/Status.pm) perl(IPC/Run.pm) perl(LWP/MediaTypes.pm) perl(LWP/Protocol.pm) perl(Test.pm) perl(URI/Escape.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2
Release: alt1
Summary: LWP back-end for rsync:// by running the rsync program.
Group: Development/Perl
License: gpl
URL: http://user42.tuxfamily.org/lwp-protocol-rsync/index.html

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/K/KR/KRYDE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module adds `rsync://' protocol scheme to `LWP::UserAgent' by running
the external the rsync(1) manpage program.

=over

http://rsync.samba.org/

=back

The rsync protocol uploads or downloads files by sending only changed file
blocks if possible.  (The receive side calculates MD4 checksums over
existing content and tells the send side what it already has.)

See RFC 5781 on the `rsync://' schema and see the Perl the URI manpage module for
manipulations of such URIs.

=over

=item *

`GET' downloads a file from an rsync server.

If an existing `:content_file' is specified as the local destination (see
the REQUEST METHODS entry in the LWP::UserAgent manpage) then that file is updated as necessary
per the rsync protocol.  `GET' to an ordinary `HTTP::Response' downloads
the full source content.

`If-Modified-Since' is implemented by getting a listing from the server and
comparing the desired time.  The response is "304 Not Modified" in the usual
way if the server time is not newer.

`Last-Modified' response is the modification time of the file on the
server.  For `:content_file' the destination file modification time is set
too.

`Content-Type' response is guessed from the URI by the LWP::MediaTypes manpage.
This is slightly experimental.  The rsync server has no notion of
`Content-Type' as such.

=item *

`HEAD' retrieves information about a file by asking for a listing from the
server.  `Content-Length' and `Last-Modified' response headers are parsed
out of the listing.

=item *

`PUT' uploads content to a file on the server.  The rsync protocol means
only changed parts of the content are actually sent.

An upload requires a writable destination on the server (see
the rsyncd.conf(5) manpage).  If it's not writable then `rsync' version 3.1.0 server
has been seen simply dropping the connection, resulting in a rather
uninformative error message "Connection reset by peer".  The intention would
be "405 Method Not Allowed" or some such if unwritable can be distinguished
from actual connection trouble.

=back

Characters `*' `?' `[' are not permitted in paths.  The intention is for
this interface to access a single file resource (read or write), but
`rsync' interprets these characters as shell style wildcards for multi-file
transfers.  IPv6 style brackets `[::1]' in the hostname part are allowed.

The `rsync' program has many options for things like mirroring whole
directory trees and that sort of thing is best done by running `rsync'
directly, or perhaps the `File::Rsync' front-end or `File::RsyncP'
protocol.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes
%perl_vendor_privlib/L*

%changelog
