%define module_name LWP-UserAgent-Throttled
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(HTTP/Request.pm) perl(HTTP/Response.pm) perl(IO/Socket/INET.pm) perl(LWP.pm) perl(LWP/Protocol/https.pm) perl(LWP/UserAgent.pm) perl(Test/DescribeMe.pm) perl(Test/Exception.pm) perl(Test/Most.pm) perl(Test/Needs.pm) perl(Test/NoWarnings.pm) perl(Test/Timer.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.12
Release: alt1
Summary: Throttle requests to a site
Group: Development/Perl
License: open_source
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Some sites with REST APIs, such as openstreetmap.org, will blacklist you if you do too many requests.
LWP::UserAgent::Throttled is a sub-class of LWP::UserAgent.

    use LWP::UserAgent::Throttled;
    my $ua = LWP::UserAgent::Throttled->new();
    $ua->throttle({ 'www.example.com' => 5 });
    print $ua->get('http://www.example.com');
    sleep (2);
    print $ua->get('http://www.example.com');_# Will wait at least 3 seconds before the GET is sent

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE README.md Changes
%perl_vendor_privlib/L*

%changelog
