%define module_name Lingua-RU-Declension
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Share.pm) perl(File/ShareDir/Install.pm) perl(Test/More.pm) perl(Test/More/UTF8.pm) perl(Text/CSV.pm) perl(charnames.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: Decline Russian pronouns, adjectives and nouns
Group: Development/Perl
License: perl
URL: https://metacpan.org/dist/lingua-ru-declension

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MA/MALLEN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use 5.014;
    use utf8;

    use Lingua::RU::Declension;

    my $rus = Lingua::RU::Declension->new();

    # Decline all words to accusitive case
    my $case = 'acc';
    my $friend = '.E.e.'.u';
    my $acc_friend = $rus->decline_noun(friend, $case); # .E.e.'.u.O
    my $acc_new = $rus->decline_adjective('.A.'.B.'.v', $friend, $case); # .A.'.B.'.u.'
    my $acc_our = $rus->decline_pronoun('.A.O.'', $friend, $case); # .A.O.'e.u.'

    # .U .B.a.c.' .A.O.'e.u.' .A.'.B.'.u.' .E.e.'.u.O!
    say $rus->russian_sentence_stem($case) . " $acc_our $acc_new $acc_friend!";

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE
%perl_vendor_privlib/L*
%perl_vendor_privlib/auto/*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
