%define module_name Lingua-TH-Numbers
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Module/Build.pm) perl(Test/Exception.pm) perl(Test/FailWarnings.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.0
Release: alt1
Summary: Convert and spell Thai numbers.
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Lingua-TH-Numbers

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AU/AUBERTG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
use Lingua::TH::Numbers;

_# Input.
_my $ten = Lingua::TH::Numbers->new( '10' );
_my $sip = Lingua::TH::Numbers->new( '.v'.v'' );
_my $lop_sip = Lingua::TH::Numbers->new( '-.v'.v'' );
_my $three_point_one_four = Lingua::TH::Numbers->new( '3.14' );
_my $nueng_chut_sun_song = Lingua::TH::Numbers->new( '.v'..v'.v'' );

_# Output.
_print $ten->thai_numerals(), "\n";
_print $sip->arabic_numerals(), "\n";
_print $lop_sip->arabic_numerals(), "\n";
_print $three_point_one_four->thai_numerals(), "\n";
_print $nueng_chut_sun_song->arabic_numerals(), "\n";

_# Spell.
_print $three_point_one_four->spell(), "\n";
_print $three_point_one_four->spell( output_type => 'thai' ), "\n";
_print $nueng_chut_sun_song->spell( output_type => 'rtgs' ), "\n";
_print $nueng_chut_sun_song->spell( output_type => 'rtgs', informal => 1 ), "\n";



%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md ignore.txt LICENSE examples
%perl_vendor_privlib/L*

%changelog
