# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Module/Build.pm) perl(Module/Load.pm) perl(Moose.pm) perl(POSIX.pm) perl(Search/Tokenizer.pm) perl(Test/More.pm) perl(namespace/clean.pm)
# END SourceDeps(oneline)
%define module_name Lingua-Thesaurus
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.13
Release: alt1
Summary: Thesaurus management
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DA/DAMI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This distribution manages *thesauri*. A thesaurus is a list of
terms, with some relations (like for example "broader term" /
"narrower term"). Relations are either "internal" (between two terms),
or "external" (between a term and some external data, like for example
a "Scope Note"). Relations may have a reciprocal;
see the Lingua::Thesaurus::RelType manpage.

Thesauri are loaded from one or several *IO formats*; usually this will be
the ISO 2788 format, or some derivative from it. See classes under the
the Lingua::Thesaurus::IO manpage namespace for various implementations.

Once loaded, thesauri are stored via a *storage class*; this is
meant to be an efficient internal structure for supporting searches.
Currently, only the Lingua::Thesaurus::Storage::SQLite manpage is implemented;
but the architecture allows for other storage classes to be defined,
as long as they comply with the the Lingua::Thesaurus::Storage manpage role.

Terms are retrieved through the the section on "search_terms" and the section on "fetch_term"
methods. The results are instances of the Lingua::Thesaurus::Term manpage;
these objects have navigation methods for retrieving related terms.

This distribution was originally targeted for dealing with the
Swiss thesaurus for justice "Jurivoc"
(see the Lingua::Thesaurus::IO::Jurivoc manpage).
However, the framework should be easily extensible to other needs.
Other Perl modules for thesauri are briefly discussed below
in the the section on "SEE ALSO" section.

Side note: another motivation for writing this distribution was also
to experiment with the Moose manpage meta-programming possibilities.
Subclasses of the Lingua::Thesaurus::Term manpage are created dynamically
for implementing relation methods `NT', `BT', etc. ---
see the Lingua::Thesaurus::Storage manpage source code.

Caveat: at the moment, IO classes only implement loading and
searching; methods for editing and dumping a thesaurus will be added in a
future version.



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%changelog
