%define module_name Lingua-TokenParse
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Math/BaseCalc.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Wordlist.pm) perl(Storable.pm) perl(Test/EOL.pm) perl(Test/More.pm) perl(Test/NoTabs.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Spelling.pm) perl(Test/Synopsis.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1602
Release: alt1
Summary: Parse a word into scored, fragment combinations
Group: Development/Perl
License: perl
URL: https://github.com/ology/Lingua-TokenParse

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GE/GENE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This class represents a Lingua::TokenParse object and contains
methods to parse a given word into familiar combinations based
on a lexicon of known word parts.  This lexicon is a simple
*fragment => definition* list.

Words like "automobile" and "deoyribonucleic" are composed of
different roots, prefixes, suffixes, etc.  With a lexicon of known
fragments, a word can be partitioned into a list of its (possibly
overlapping) known and unknown fragment combinations.

These combinations can be given a score, which represents a measure of
word familiarity.  This measure is a set of ratios of known to unknown
fragments and letters.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md README
%perl_vendor_privlib/L*

%changelog
