%define module_name Linux-Clone
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.3
Release: alt1
Summary: an interface to the linux clone(2) and unshare(2) syscalls
Group: Development/Perl
License: see COPYING
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ML/MLEHMANN/%{module_name}-%{version}.tar.gz

%description
This module exposes the linux clone(2), unshare(2) and related syscalls to
Perl.

=over 4

=item $retval = unshare $flags

The following CLONE_ flag values (without CLONE_ prefix) are supported for
unshare, if found, in this release. See the documentation for unshare(2)
for more info on what they do:

   Linux::Clone::FILES
   Linux::Clone::FS
   Linux::Clone::NEWNS   (in unshare, implies FS)
   Linux::Clone::VM      (in unshare, implies SIGHAND)
   Linux::Clone::THREAD  (in unshare, implies VM, SIGHAND)
   Linux::Clone::SIGHAND
   Linux::Clone::SYSVSEM
   Linux::Clone::NEWUSER (in unshare, implies CLONE_THREAD)
   Linux::Clone::NEWPID
   Linux::Clone::NEWUTS
   Linux::Clone::NEWIPC
   Linux::Clone::NEWNET
   Linux::Clone::NEWCGROUP

Example: unshare the network namespace and prove that by calling ifconfig,
showing only an unconfigured lo interface.

   Linux::Clone::unshare Linux::Clone::NEWNET
      and "unshare: $!";
   system "ifconfig -a";

Example: unshare the network namespace, initialise the loopback interface,
create a veth interface pair, put one interface into the parent processes
namespace (use ifconfig -a from another shell), configure the other
interface with 192.168.99.2 -> 192.168.99.1 and start a shell.

   use Linux::Clone;

   # unshare our network namespace
   Linux::Clone::unshare Linux::Clone::NEWNET
     and "unshare: $!";

   my $ppid = getppid;

   system "
      # configure loopback interface
      ip link set lo up
      ip route add 127.0.0.0/8 dev lo

      # create veth pair
      ip link add name veth_master type veth peer name veth_slave

      # move veth_master to our parent process' namespace
      ip link set veth_master netns $ppid

      # configure the local interface
      ip link set veth_slave up
      ip addr add 192.168.99.2/32 dev veth_slave
      ip route add 192.168.99.1/32 dev veth_slave
   ";

   print <<EOF;
   say hi to your new network namespace, use exit to return.

   try this from another shell to get networking up:

   ip link set veth_master up
   i...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README COPYING
%perl_vendor_archlib/L*
%perl_vendor_autolib/*

%changelog
