# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Cwd.pm) perl(ExtUtils/CBuilder.pm) perl(Fcntl.pm) perl(Module/Build.pm) perl(POSIX.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 0.08
%define module_name Linux-RTC-Ioctl
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt6
Summary: Real Time Clock access using the Linux driver ioctl interface.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TO/TOUGHY/%{module_name}-%{module_version}.tar.gz

%description
`$device' can be an open file handle, a device file name, a device number
(0, 1, 2..) or empty (`undef'), in which case /dev/rtc is used.

The Linux driver has built-in locking so that only one process can have the
/dev/rtc interface open at a time. You must be root or must have permissions
to access the device file, according to the usual file owner and group. User
processes than can access the device, still need to have the CAP_SYS_TIME
capability in order to use the `$rtc->set_time' method.

Beware the RTC time runs in the RTC time zone, which is not the same as the 
local time zone of the system, as it can also be GMT. To prevent problems with
the transition to and from DST (daylight saving time), the RTC should run in the
GMT time zone, which is usually the default for the Linux setup. Note there is no
why to retrieve this time zone from the RTC device, the system stores this
information elsewhere (see the manual page for the `hwclock` command for more
details). Even if you know the RTC time zone, the RTC time will not accurately
match the system time. Linux OS learns how fast the RTC time is running compared
to real time, and if it is not accurate, Linux will constantly adjust the RTC
(every 11 min) to keep it close to the real time.

Any functionality described here is present only when supported by the RTC
hardware. Methods that access the device return `undef' in case of error,
in which case you can read the system error variable `$!'. Methods are
defined only if the corresponding ioctl request is defined for the platform,
you can check for example `defined \&Linux::RTC::Ioctl::set_wakeup_alarm'.

All methods can take the date-time components from:

=over 4

=item * the argument list (if arguments are passed)

=item * the `$rtc' object fields (empty arguments list)

=back

All methods can return the date-time components as:

=over 4

=item * function result (if called in list context)

=item * the `$rtc' object fields (in scalar or void context)

=back

All information here is taken from:

=over ...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/L*
%perl_vendor_autolib/*

%changelog
