BuildRequires: /proc
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/VarPrint.pm) perl(ExtUtils/MakeMaker.pm)
# END SourceDeps(oneline)
%define module_version 1.00
%define module_name Linux-stat
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: parse /proc/stat
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/V/VS/VSEGO/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Linux::stat is a simple Perl module which parses /proc/stat file.  
Info is arranged in hash reference with descriptive keys.

Linux::stat was written on RedHat Linux 7.2, kernel 2.4.7 and tested on
RedHat 6.2, kernel 2.2.14. It is expected to work with other versions as
well, but this depends on Linux configuration and kernel version.

Output data can be easily previewed with Data::VarPrint package, 
available at CPAN.

Output fields (some of these are unavailable on kernels older than 2.4):

=over 4

=item boot_timestamp

Timestamp (number of seconds since epoch) when the system was booted

=item context_switch

Context switch, used by Linux job scheduler; for more info check Linux
kernel sources: kernel/sched.c (look for kstat.context_swtch)

=item cpu, cpu0, cpu1,...

Overall and per-CPU time: user, nice, system, idle

=item disks

Disks I/O (for each partition):

=over 4

=item disk - disk number (0 for /dev/hda, 1 for /dev/hdb,...)

=item io - total number of I/O requests

=item major - major disk number (partition number on the disk)

=item read_count - number of reads from disk

=item read_sectors - number of sectors read from disk

=item write_count - number of writes to disk

=item write_sectors - number of sectors written to disk

=back

=item disks_io

Overall disk I/O info; same fields as in disks (of course, except for
disk and major)

=item interrupts

Number for interrupts for each IRQ

=item interrupts_total

Total number of interrupts (same as sum of all numbers in interrupts)

=item kstat.*

Not parsed, just added to hash

=item pages_in

Number of pages read

=item pages_out

Number of pages written

=item swap_pages_in

Number of pages read from swap

=item swap_pages_out

Number of pages written to swap

=item total_forks

Number of processes run since boot

=item uptime

System uptime in seconds (same as sum of all four times for cpu)

=back

All not-recognized fields are just passed on without parsing.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%changelog
