# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(CopyTree/VendorProof.pm) perl(Data/Dumper.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(HTTP/DAV.pm) perl(MIME/Base64.pm) perl(Moose.pm) perl(MooseX/NonMoose.pm) perl(Term/ReadKey.pm) perl(Test/More.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_version 0.0013
%define module_name Livelink-DAV
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.0013
Release: alt1
Summary: Perl extension for providing a Opentext Livelink EWS WebDAV connecter instance for CopyTree::Vendor...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DB/DBMOLESTA/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Livelink::DAV provides different types of methods.  

First, it provides connection methods to allow us to connect to Livelink EWS's WebDAV.  These connection methods that you see in the SYNOPSIS are pretty self explanatory. 

Second, Livelink::DAV provides methods for its parent class (CopyTree::VendorProof), which includes

   new
   fdls           
   is_fd
   read_info_memory
   write_from_memory
   copy_local_files
   cust_mkdir
   cust_rmdir
   cust_rmfile

The functionality of these methods are described in 

perldoc CopyTree::VendorProof 

It is worth nothing that fdls comes in quite handy for testing whether you can actually connect to your livelink resource using this module.  Simply open up your web browser and go to your livelink site, and fdls any resource that has a webdav property.  If you do a Dumper print, you should get something back.

   use Data::Dumper;
   print Dumper $llobj -> fdls('', '~username/');




%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%changelog
