%define module_name Log-Any-Adapter-Coderef
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/Any.pm) perl(Sys/Hostname.pm) perl(Test/CheckDeps.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: Provide stacktrace and other information to generic Log::Any handlers
Group: Development/Perl
License: perl
URL: https://github.com/team-at-cpan/Log-Any-Adapter-Coderef

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TE/TEAM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Provides support for sending log messages through a custom `sub', for cases when
you want to do something that isn't provided by existing adapters.

Currently takes a single `$code' parameter as a callback. This will be
called for every log message, passing a hashref which has the following keys:

=over 4

=item * `epoch' - current time, as a floating-point epoch value

=item * `severity' - log level, e.g. `info' or `debug'

=item * `message' - the formatted log message

=item * `host' - current hostname

=item * `pid' - current process ID (the section on "$$" in the perlvar manpage)

=item * `stack' - arrayref of stacktrace entries, see the caller manpage

=back

Additional keys may be added in future, for example structured data.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/L*

%changelog
