%define module_name Log-Any-Adapter-DERIV
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Clone.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(File/HomeDir.pm) perl(File/Spec.pm) perl(Future.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(JSON/MaybeUTF8.pm) perl(Log/Any.pm) perl(Log/Any/Adapter.pm) perl(Log/Any/Adapter/Coderef.pm) perl(Log/Any/Adapter/Util.pm) perl(Log/Any/Proxy.pm) perl(Log/Any/Test.pm) perl(Path/Tiny.pm) perl(PerlIO.pm) perl(Syntax/Keyword/Try.pm) perl(Sys/Hostname.pm) perl(Term/ANSIColor.pm) perl(Test/CheckDeps.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/Fatal.pm) perl(Test/MockModule.pm) perl(Test/MockTime/HiRes.pm) perl(Test/More.pm) perl(Time/Moment.pm) perl(XS/Parse/Keyword.pm) perl(curry.pm) perl(feature.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.009
Release: alt1
Summary: one company's example of a standardised logging setup
Group: Development/Perl
License: perl
URL: https://github.com/awais-deriv/perl-Log-Any-Adapter-DERIV

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DE/DERIV/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Applies some opinionated log handling rules for the Log::Any manpage.

This is extremely invasive. It does the following, affecting global state
in various ways:

=over 4

=item * applies UTF-8 encoding to STDERR

=item * writes to a `.json.log' file.

=item * overrides the default the Log::Any::Proxy manpage formatter to provide data as JSON

=item * when stringifying, may replace some problematic objects with simplified versions

=back

An example of the string-replacement approach would be the event loop in asynchronous code:
it's likely to have many components attached to it, and dumping that would effectively end up
dumping the entire tree of useful objects in the process. This is a planned future extension,
not currently implemented.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes examples
%perl_vendor_privlib/L*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
