# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Log/Any.pm) perl(Test/More.pm) perl(Time/HiRes.pm) perl(constant.pm)
# END SourceDeps(oneline)
%define module_name Log-Any-Progress
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: log incremental progress using Log::Any
Group: Development/Perl
License: artistic_2
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LA/LARRYL/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module makes it easy to use the Log::Any manpage to log incremental
progress, similar in concept to the Term::ProgressBar manpage.  It can be
useful for monitoring the progress of a long-running process and to
get an idea of how long that process might take to finish.

It is generally applied to a processing loop.  In the typical case
where the expected number of iterations is known in advance, it
produces output containing the iteration count, percent completion,
elapsed time, average time per iteration, and estimated time remaining.
For example:

  Progress: Iteration:0/5 0%% STARTING
  Progress: Iteration:1/5 20%% Elapsed:2.000s Avg:2.000s Remaining:8.001s
  Progress: Iteration:2/5 40%% Elapsed:4.001s Avg:2.000s Remaining:6.001s
  Progress: Iteration:3/5 60%% Elapsed:6.001s Avg:2.000s Remaining:4.001s
  Progress: Iteration:4/5 80%% Elapsed:8.001s Avg:2.000s Remaining:2.000s
  Progress: Iteration:5/5 100%% FINISHED Elapsed:10.002s Avg:2.000s

The remaining time estimate as of any particular iteration is a
simple linear calculation based on the average time per iteration up
to that point, and the number of remaining iterations.

If the expected number of iterations is not known in advance, it still
reports on incremental progress, but cannot compute either percent
completion or estimated remaining time.  For example:

  Progress: Iteration:0 STARTING
  Progress: Iteration:1 Elapsed:2.000s Avg:2.000s
  Progress: Iteration:2 Elapsed:4.001s Avg:2.000s
  Progress: Iteration:3 Elapsed:6.001s Avg:2.000s
  Progress: Iteration:4 Elapsed:8.001s Avg:2.000s
  Progress: Iteration:5 Elapsed:10.001s Avg:2.000s

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/L*

%changelog
