%define module_name Log-Colorize-Helper
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Error/Helper.pm) perl(String/ShellQuote.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.1
Release: alt1
Summary: Makes searching and colorizing logs trivial with out all the need for piping
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VV/VVELOX/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use Log::Colorize::Helper;
    use Getopt::Std;
    
    #gets the options
    my %%opts=();
    getopts('efhtn:g:ivlFGJ', \%%opts);
    
    #init it
    my $clog=Log::Colorize::Helper->new;
    
    #set tail/head stuff if needed
    if ( ! defined( $opts{n} ) ){
    _$opts{n}=10;
    }
    if ( $opts{t} ){
    _$opts{t}=$opts{n};
    }
    if ( $opts{h} ){
    _$opts{h}=$opts{n};
    }
    
    $clog->colorize(
    _{
    __echo=>$opts{e},
    __log=>$ARGV[0],
    __head=>$opts{h},
    __tail=>$opts{t},
    __grep=>$opts{g},
    __less=>$opts{l},
    __follow=>$opts{f},
    __'grep-insensitive'=>$opts{i},
    __'grep-invert'=>$opts{v},
    __'grep-first'=>$opts{F},
    __bzip2=>$opts{J},
    __gzip=>$opts{G},
    _}
    _);

This module uses the Error::Helper manpage for error reporting.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README ignore.txt Changes
%perl_vendor_privlib/L*

%files scripts
%_bindir/*

%changelog
