%define module_name Log-Dispatch-Gelf
# BEGIN SourceDeps(oneline):
BuildRequires: perl(IO/Uncompress/Gunzip.pm) perl(JSON/MaybeXS.pm) perl(Log/Dispatch.pm) perl(Log/GELF/Util.pm) perl(Mock/Quick.pm) perl(Module/Build/Tiny.pm) perl(Params/Validate.pm) perl(Test/Exception.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.4.0
Release: alt1
Summary: Log::Dispatch plugin for Graylog's GELF format.
Group: Development/Perl
License: perl
URL: https://github.com/JaSei/log-dispatch-gelf

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JA/JASEI/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Log::Dispatch::Gelf is Log::Dispatch plugin which formats the log message
according to Graylog's GELF Format version 1.1 and sends it using user-provided
sender.

The constructor takes the following parameters in addition to the standard
parameters documented in the Log::Dispatch::Output manpage:

=over

=item additional_fields

optional hashref of additional fields of the gelf message (no need to prefix
them with _, the prefixing is done automatically).

=item send_sub

mandatory sub for sending the message to graylog. It is triggered after the
gelf message is generated.

=back



%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/L*

%changelog
