# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Log-Dump
%define upstream_version 0.14

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_9

Summary:    Simple logger mainly for debugging
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Log/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Data/Dump.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(ExtUtils/MakeMaker/CPANfile.pm)
BuildRequires: perl(IO/Capture.pm)
BuildRequires: perl(IO/File.pm)
BuildRequires: perl(Sub/Install.pm)
BuildRequires: perl(Test/Classy.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/UseAllModules.pm)
BuildArch: noarch
Source44: import.info

%description
the Log::Dump manpage is a simple logger mix-in mainly for debugging. This
installs six methods into a caller (the class that 'use'd the Log::Dump
manpage) via the Sub::Install manpage. The point is you don't need to load
extra dumper modules or you don't need to concatenate messages. Just log
things and they will be dumped (and concatenated if necessary) to stderr,
and to a file if you prefer. Also, you can use these logging methods as
class methods or object methods (though usually you don't want to mix them,
especially when you're doing something special).

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc META.yml README Changes
%perl_vendor_privlib/*




%changelog
