# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Config/General.pm) perl(Config/Properties.pm) perl(DBD/mysql.pm) perl(DBI.pm) perl(Email/Date.pm) perl(Module/Build.pm) perl(Net/SMTP.pm) perl(Text/CSV.pm) perl(YAML.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Log-Handler
%define upstream_version 0.90

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_2

License:    GPL+ or Artistic
Group:      Development/Perl
Summary:    A simple log file handler
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Log/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Fcntl.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(POSIX.pm)
BuildRequires: perl(Params/Validate.pm)
BuildRequires: perl(Sys/Hostname.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Time/HiRes.pm)
BuildRequires: perl(UNIVERSAL.pm)
BuildArch:  noarch
Source44: import.info

%description
This module is just a simple object oriented log file handler and very easy to
use.  It's possible to define a log level for your programs and control the
amount of informations that will be logged to the log file. In addition it's
possible to configure how you wish to open the log file - transient or
permanent - and lock and unlock the log file by each write operation. If you
wish you can assign the handler to check the inode of the log file (not on
Windows). That could be very useful if a rotate mechanism moves and zip the log
file.

%prep
%setup -q -n %{upstream_name}-%{upstream_version} 

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
make test

%install
%makeinstall_std

%files
%doc ChangeLog INSTALL LICENSE META.json META.yml  README examples
%{perl_vendor_privlib}/*

%changelog
