%define module_name Log-OK
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Log/Any.pm) perl(Log/Any/Adapter.pm) perl(Log/Dispatch.pm) perl(Log/Log4perl.pm) perl(Log/Log4perl/Level.pm) perl(Log/ger.pm) perl(Log/ger/Output.pm) perl(Log/ger/Util.pm) perl(constant/more.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.1
Release: alt1
Summary: Disable inactive logging statements from the command line
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRCLAW/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
the Log::OK manpage creates compile time constants/flags for each level of logging
supported in your selected logging framework.  This module does not implement
logging features, only constants to help enable/disable logging efficiently.

If your selected logging system was the Log::ger manpage, and the logging level was set
to "info" for example, the constants generated would be:

_Log::OK::FATAL _= 1;
_Log::OK::ERROR _= 1;
_Log::OK::WARN _= 1;
_Log::OK::INFO _= 1;
_Log::OK::DEBUG _= undef;
_Log::OK::TRACE _= undef;

The value of constants are determined from the logging level specified in code,
from the command line (set or increment) or an environment variable of your
choosing.

The idea is to have a logger independent method of completely disabling inactive
logging statements to reduce runtime overhead.

By using the generated constants/flags in the following fashion, perl will
optimise away this entire statement when `Log::OK::DEBUG' is false for example:

__Log::OK::FATAL and log_fatal("Fatal");

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes README.md examples
%perl_vendor_privlib/L*

%changelog
