Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Log-TraceMessages
Version:        1.4
Release:        alt3_45
Summary:        Perl extension for trace messages used in debugging

License:        GPL+ or Artistic
URL:            https://metacpan.org/release/Log-TraceMessages
Source0:        https://cpan.metacpan.org/modules/by-module/Log/Log-TraceMessages-%{version}.tar.gz
# Restore compatibility with Perl 5.26.0, CPAN RT#115089
Patch0:         Log-TraceMessages-1.4-Use-File-Temp-tempfile-instead-of-POSIX-tmpnam.patch

BuildArch:      noarch
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(AutoLoader.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(HTML/FromText.pm)


Source44: import.info

%description
This module is a better way of putting 'hello there' trace messages in
your code.  It lets you turn tracing on and off without commenting out
trace statements, and provides other useful things like HTML-ified
trace messages for CGI scripts and an easy way to trace out data
structures using Data::Dumper.


%prep
%setup -q -n Log-TraceMessages-%{version}
%patch0 -p1


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build


%install
make pure_install PERL_INSTALL_ROOT=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} ';'


%check
make test


%files
%doc Changes README
%{perl_vendor_privlib}/Log/
%{perl_vendor_privlib}/auto/*


%changelog
