%define module_name Log-ger-App
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/ger.pm) perl(Log/ger/Layout/Pattern.pm) perl(Log/ger/Output.pm) perl(Log/ger/Output/Composite.pm) perl(Log/ger/Output/File.pm) perl(Log/ger/Output/Screen.pm) perl(Log/ger/Output/Syslog.pm) perl(Log/ger/Util.pm) perl(PERLANCAR/File/HomeDir.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.025
Release: alt1
Summary: An easy way to use Log::ger in applications
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Log-ger-App

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module basically loads the Log::ger::Output::Composite manpage with some sensible
defaults and allows customizing some aspects via environment variable.

Outputs:

 Code                            Screen  File                   Syslog
 ------------------------------  ------  ----                   ------
 One-liner (-e)                  y       -                      -
 Script running as normal user   y       ~/PROGNAME.log         -
 Script running as root          y       /var/log/PROGNAME.log  -
 Daemon                          -       /var/log/PROGNAME.log  y

General log level: the default is `warn' (like the Log::ger manpage's default). You
can set it from environment using the LOG_LEVEL manpage (e.g. `LOG_LEVEL=trace' to set
level to trace or the LOG_LEVEL=0 entry elsewhere in this document to turn off logging). Alternatively, you can
set to `trace' using `TRACE=1', or `debug' with `DEBUG=1', `info' with
`VERBOSE=1', `error' with `QUIET=1'.

Per-output level: the default is to use general level, but you can set a
different level using *OUTPUT_NAME*_{`LOG_LEVEL|TRACE|DEBUG|VERBOSE|QUIET'}
variables. For example, `SCREEN_DEBUG=1' to set screen level to `debug' or
`FILE_LOG_LEVEL=off' to turn off file logging.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/L*

%changelog
