# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Log/ger.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define module_name Log-ger-Level-Like-LogAny
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.001
Release: alt1
Summary: Define logging levels like Log::Any
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Log-ger-Level-Like-LogAny

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module changes the the Log::ger manpage levels to:

    emergency => 5,
    alert     => 6,
    critical  => 10,
    crit      => 10, # = critical
    fatal     => 10, # = critical
    error     => 20,
    err       => 20, # = error
    warning   => 30,
    warn      => 30, # = warning
    notice    => 35,
    info      => 40,
    inform    => 40, # = info
    debug     => 50,
    trace     => 60,

Note that the exact numerical constants differ from definitions in
the Log::Any::Adapter::Util manpage. The numbers are adjusted so things like
the Log::ger::Output::Screen manpage can show colors that are more equivalent.

The aliases names are defined as proper levels too so you get `log_crit',
`log_err', and so on.
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes LICENSE README
%perl_vendor_privlib/L*

%changelog
