%define module_name LogCarp
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(Fcntl.pm) perl(SelectSaver.pm) perl(Symbol.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 4.48
Release: alt1
Summary: Error, log and debug streams, httpd style format
Group: Development/Perl
License: see LICENSE
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/MI/MIKEKING/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
CGI::LogCarp is a Perl package defining methods for directing
the existing STDERR stream as well as creating and directing
two new messaging streams, STDBUG and STDLOG.

Their use was intended mainly for a CGI development environment,
or where separate facilities for errors, logging, and debugging
output are needed.

This is because CGI scripts have a nasty habit of leaving warning messages
in the error logs that are neither time stamped nor fully identified.
Tracking down the script that caused the error is a pain. Differentiating
debug output or activity logging from actual error messages is a pain.
Logging application activity or producing debugging output are quite different
tasks than (ab)using the server's error log for this purpose.
This module fixes all of these problems.

Replace the usual

    use Carp;

or

    use CGI::Carp;

with

    use CGI::LogCarp;

And the standard `warn()', `die()', `croak()', `confess()',
`cluck()', and `carp()' calls will automagically be replaced with methods
that write out nicely time-, process-, program-, and stream- stamped messages
to the STDERR, STDLOG, and STDBUG streams.

The method to generate messages on the new STDLOG stream
is `logmsg()'. Calls to `logmsg()' will write out the same nicely
time-, process-, program-, and stream-stamped messages
described above to both the STDLOG and the STDBUG streams.

The process number and the stream on which the message appeared
is embedded in the default message in order to disambiguate multiple
simultaneous executions as well as multiple streams directed
to the same location.

Messages on multiple streams directed to the same location
do not receive multiple copies.

Methods to generate messages on the new STDBUG stream
are `debug()' and `trace()'.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc TODO LICENSE README CONTRIBUTING Changes
%perl_vendor_privlib/C*

%changelog
