# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(List/Compare/Functional.pm) perl(Module/Build.pm) perl(Moose.pm) perl(Test/More.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_name Logic-Minimizer
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: Parent class for Logic minimizers like Quine-McCluskey
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JG/JGAMBLE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is the base class for logic minimizers that are used by
the Logic::TruthTable manpage. You do not need to use this class (or
indeed read any further) unless you are creating a logic
minimizer package.

    package Algorithm::SomethingNiftyLikeEspresso;
    extends 'Logic::Minimizer';

(`Algorithm::SomethingNiftyLikeEspresso' has `Logic::Minimizer'
as its base class, which is required if `Logic::TruthTable' is to
use it.)

Then, either use the package directly in your program:

    my $fn = Algorithm::SomethingNiftyLikeEspresso->new(
        width => 4,
        minterms => [1, 8, 9, 14, 15],
        dontcares => [2, 3, 11, 12]
    );
    ...

or as a algorithm choice in `Logic::TruthTable':

    my $tt = Logic::TruthTable->new(
        width => 4,
        algorithm => 'SomethingNiftyLikeEspresso',
        columns => [
            {
                minterms => [1, 8, 9, 14, 15],
                dontcares => [2, 3, 11, 12],
            }
            {
                minterms => [4, 5, 6, 10, 13],
                dontcares => [2, 3, 11, 12],
            }
        ],
    );

This class provides the attributes and some of the methods for your
minimizer class.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/L*

%changelog
