# BEGIN SourceDeps(oneline):
BuildRequires: perl(MIDI.pm) perl(Module/Build.pm) perl(Test2/V0.pm)
# END SourceDeps(oneline)
%define module_name MIDI-Segment
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: means to segment MIDI by equal duration
Group: Development/Perl
License: bsd
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/J/JM/JMATES/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a means to split the MIDI::Opus manpage into the MIDI::Event manpage
segments of equal duration, assuming that is possible. Typical uses
would be to display the possible segments or to shuffle them into a new
composition with e.g. the shuffle call in the List::Util manpage.

MIDI does not contain durations; the *dtime* or "delta time" of the
last `note_on' event of track may be `0'; if that `note_on' is the
last event of the track then the duration of that note is unknown. Also
MIDI tracks may be of different durations. These cases are not handled
by this module; the user will need to alter the MIDI so that the tracks
are of equal duration and the last `note_on' events have a suitable
*dtime* set. the MIDI::Event manpage may be helpful to study if this paragraph
did not make much sense, and inspecting the contents of MIDI files with
`eg/midi-dump'.

  $ perl ./eg/midi-dump t/cowbell.midi

Other problems with MIDI include that zero *dtime* events can be
associated with either some previous or next event; worse, these might
be ordered so that the control change for the future note happens prior
to the off event of the previous note. This has been a long way to say
that random MIDI may not segment itself cleanly.

Lilypond MIDI files in particular contain a control track that will need
to be removed as this track contains no note_on events.

  my $opus = MIDI::Opus->new( { from_file => 'lilypond.midi' } );
  shift @{ $opus->tracks_r };
  my ( $mis, $durations ) = ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/M*

%changelog
