%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(AutoLoader.pm) perl(DB_File.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(IO/Socket/INET.pm)
# END SourceDeps(oneline)
%define module_version 0.07
%define module_name MMM-Text-Search
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Perl module for indexing and searching text files and web objects
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MAXM/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
=item_*
Indexing

When a session is closed the following files will have been created 
(assuming IndexPath = /path/myindex.db, see constructor):
 

_/path/myindex.db_     word index database
_/path/myindex-locations.db   filename/URL database
_/path/myindex-titles.db_     html title database
_/path/myindex.stopwords_     stop-words list
_/path/myindex.filelist_     readable list of indexed files/URLs
_/path/myindex.deadlinks_     broken http links

_[... lots of important things missing ... ]

start_indexing_session() starts session.
_
commit_indexing_session() commits and closes current session.
  
index_default_locations() indexes all files and URLs specified on construction.

index_content() pushes content into indexing engine. 
Argument must have the following structure
__
 { title =>   '...', content=>  '...', id =>      '...'  }


makeindex() is obsolete.
        Equivalent to:
          $srch->start_indexing_session();
          $srch->index_default_locations();
          $srch->commit_indexing_session();




dump_word_stats(\*FH) dumps all words sorted by occurence frequency using
FH file handle (or STDOUT if no parameter is specified). Stop-words get a 
frequency value of 1.

=item *
Searching

Both query() and advanced_query() return a reference to a hash with 
the following structure:

_(
_ ignored  => [ string, string, ... ], # ignored words
_ searched => [ string, string, ... ], # words searched for
_ entries    => [  hashref, hashref, ... ] # list of records 
______# found
_ )
_
The 'entries' element is a reference to an array of hashes, each having 
the following structure:

_(
 _ location => string,  # file path or URL or anything
_ score    => number,  # score 
_ title    => string   # HTML title__ 
_)


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*
%perl_vendor_privlib/auto/*

%changelog
