Epoch: 1
%def_without test
%define module_name MOP
# BEGIN SourceDeps(oneline):
BuildRequires: perl(B.pm) perl(Carp.pm) perl(Devel/Hook.pm) perl(Devel/OverloadInfo.pm) perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Sub/Metadata.pm) perl(Sub/Util.pm) perl(Symbol.pm) perl(Test/Fatal.pm) perl(Test/More.pm) perl(UNIVERSAL/Object.pm) perl(attributes.pm) perl(mro.pm) perl(parent.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.14
Release: alt2
Summary: Perl extension providing a meta-object protocol for Perl modules.
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/ST/STEVAN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides a simple and, in my opinion, powerful meta-object protocol (MOP)
for Perl5 modules.
In short, such MOP allows to *trap the method calls* made on an object
(represented by a reference) before they reach the original module implementing
them. These method calls are redirected to another module, called the meta-module,
before their execution. The original (legitimate) destination of the method call is in
the (base) module. Of course, one day or another, the meta-module should perform the actual
normal method call at the base level, but it can do some nice things before or after
doing that. And this is the whole purpose of its existence.

MOP::MOP implements the base level part of the protocol. This module is tightly
linked with module MOP::MetaModule which implements the
other upper part of the behavior, i.e. the generic behavior of a meta-module.

In the above example, MyBaseModule is the base module, and MyMetaModule is
the meta-module (not shown here). In this example, the 3 methods new(), method1()
and method3() are modified due to the MOP.
These methods become *reflective* methods. When a user of MyBaseModule calls
one of these methods, they are not called directly, but the
method meta_method_call() of MyMetaModule is called instead. This method is passed
the original arguments of the method call, prepended by the (base level) method name and
(base level) object reference or package name used.

Hence, if a programmer does:

    use MyBaseModule;
    my $obj = MyBaseModule->new($newarg);
    $obj->method1($foo, $bar);
    $obj->method2($bur);
    $obj->method3();

In fact, the actual operations taking place correspond to the following steps.

=over 4

=item 1.

`$obj = MyMetaModule->meta_method_call(new_Refl, 'MyBaseModule', $newarg)'

This occurs in place of the first call, as MyMetaModule is registered as the
meta-module of MyBaseModule.

=back

Then, supposing that at the end of this strange new() a meta-object 
referenced by $metaobj is registered for the freshly created $obj, the processing
will continue as in the following.

=over 4

=item 2.

$metaobj->meta_method_call(*method1_Refl*, $obj, $foo, $bar)

This is the call of a reflective method on $obj and such calls are
processed by the meta-object, not by perl itself directly (even though
Perl behavior remains valid somewhere else).

=item 3.

$obj->method2($bur)

This is a normal method call. As method2() is *not* reflective, the
work is done by perl itself.

=item 4.

$metaobj->meta_method_call(*method2_Refl*, $obj)

Again, a reflective method call to finish.

=back

*Note*: Here, even if they are actually used, the *blabla_Refl* names are only for
illustration. They represent the
name of the base level method. The meta-object needs them if it ever wants
the real work to be done. But note that the structure of these names may not follow
this scheme indefinitely (and these thingies may become code references in the future).
See  meta_handle_method_call() in MOP::MetaModule.

A MOP is mainly useful for modules that provide a rather strict
object-oriented interface. It allows to extend transparently the functionality
provided by such a class module in order to provide additional
properties not directly related to the module functions. This may sound rather
obscure, but it can really be useful.
For example, this is the case in the real world when you want to add transparent
distribution to your programs, when you want to enhance such distributed execution
with a CRC integrity check in messages, when you want to manage multiple replicas
of a server, etc.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE README.md
%perl_vendor_privlib/M*

%changelog
