%define _without_test 1
%define module_version 0.02
%define module_name MacPerl-AppleScript
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.02
Release: alt1
Summary: Perl extension for easily accessing scriptable Apps
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/W/WK/WKI/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module is not written for being efficient. In fact it is
really inefficient but hopefully easy to use :-)

As AppleScript (and its way of communicating to Applications) usually
has some kind of latency. The creation of readable code is the most
important goal when writing this Module.

Another reason for some kind of inefficiency results in the technical
problem that AppleScript is a strongly typed language. Converting
types back to Perl is easy. But the other direction is not always
clear, as converting a scalar from Perl to AppleScript needs some
guessing :-(

The parts of the code that deal with these problems do some tries with
different AppleScript commands wrapped in try-blocks. So usually one
of the expression works without errors. The same approach is made with
hash keys that can contain spaces or underscores inside the key name.

This module assumes that all strings are correctly encoded in perl
internal's coding sheme based on Unicode. During the conversion to
AppleScript all characters inside strings that are not ascii-clean are
converted to strange looking unicode-string constructing sequences. I
tested a lot of character schemes including west- and mid-european
languages as well as russian, greek and arabic with some applications
without getting problems.



%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
