# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dumper/Concise.pm) perl(Email/Valid.pm) perl(ExtUtils/MakeMaker.pm) perl(Moo.pm) perl(Scalar/Util.pm) perl(Test/Deep.pm) perl(Test/Exception.pm) perl(Test/More.pm) perl(Types/Standard.pm) perl(namespace/autoclean.pm)
# END SourceDeps(oneline)
%define module_name Mail-Alias-LocalFile
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.01
Release: alt1
Summary: A module for resolving email aliases and building recipient lists from a locally maintained aliases...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RB/RBREW/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
The `Mail::Alias::LocalFile' module provides functionality to resolve email addresses and aliases into a
unique list of email recipients. It handles nested aliases, validates email addresses, and
detects circular references in alias definitions.

This module is particularly useful for applications that need to expand distribution lists
or group aliases into actual email addresses while ensuring uniqueness and validity.

Use of the system aliases file when desired is supported via the special alias prefix 'mta_'.
Values with the prefix 'mta_' will not be expanded locally but will be passed to the MTA for
expansion. The 'mta_' prefix will be stripped before passing to the MTA. 

Alias keys with the 'mta_' prefix are not allowed and will be skipped with a warning.

    my $aliases = {
        'group2' => 'Mary@example.com, Joe@example.com'
        'system' => 'mta_postmaster',
        'normal' => 'normal@example.com',
    };

    use Mail::Alias::LocalFile;

    my $resolver   = Mail::Alias::LocalFile->new(aliases => $aliases);
    my $result     = $resolver->resolve_recipients([ bill@example.com group2 system ]);
    my $recipients = $result->{recipients};

    The recipients email addresses to pass to your email client code is:
        'bill@example.com,mary@example,com,joe@example.com,postmaster'

_group2 and mta_postmaster are expanded from the local aliases file
_and the postmaster alias will expand from  the system wide aliases file

%prep
%setup -q -n %{module_name}-%{version}
rm -f t/[0-9][-_]pod[-_]coverage.t t/[0-9][0-9][-_]pod[-_]coverage.t t/[0-9]pod[-_]coverage.t t/[0-9][0-9]pod[-_]coverage.t t/pod[-_]coverage.t t/[0-9][-_]podcoverage.t t/[0-9][0-9][-_]podcoverage.t t/[0-9]podcoverage.t t/[0-9][0-9]podcoverage.t t/podcoverage.t

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes
%perl_vendor_privlib/M*

%changelog
