# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(parent.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Mail-Audit
%define upstream_version 2.228

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt2_9

Summary:    Self-cleaning fork-respecting tempdirs
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Mail/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(Fcntl.pm)
BuildRequires: perl(File/HomeDir.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(File/Tempdir.pm)
BuildRequires: perl(MIME/Entity.pm)
BuildRequires: perl(Mail/Internet.pm)
BuildRequires: perl(Mail/Mailer.pm)
BuildRequires: perl(Mail/POP3Client.pm)
BuildRequires: perl(Net/SMTP.pm)
BuildRequires: perl(Parse/RecDescent.pm)
BuildArch:  noarch
Source44: import.info

%description
_procmail_ is nasty. It has a tortuous and complicated recipe format, and I
don't like it. I wanted something flexible whereby I could filter my mail
using Perl tests.

Mail::Audit was inspired by Tom Christiansen's _audit_mail_ and
_deliverlib_ programs. It allows a piece of email to be logged, examined,
accepted into a mailbox, filtered, resent elsewhere, rejected, replied to,
and so on. It's designed to allow you to easily create filter programs to
stick in a _.forward_ file or similar.

Mail::Audit groks MIME; when appropriate, it subclasses MIME::Entity. Read
the MIME::Tools man page for details.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes FAQ LICENSE META.json META.yml README
%{_bindir}/popread
%{_bindir}/proc2ma
%{_mandir}/man1/*
%{perl_vendor_privlib}/*


%changelog
