%define module_name Mail-DKIM-Iterator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Crypt/OpenSSL/RSA.pm) perl(Digest/SHA.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Net/DNS.pm) perl(Scalar/Util.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.010
Release: alt1
Summary: validate DKIM signatures and sign the asynchronous way
Group: Development/Perl
License: perl
URL: https://github.com/noxxi/p5-mail-dkim-iterator

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SU/SULLR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
With this module one can validate DKIM Signatures in mails and also create DKIM
signatures for mails.

The main difference to the Mail::DKIM manpage is that the validation can be done
iterative, that is the mail can be streamed into the object and if DNS lookups
are necessary their results can be added to the DKIM object asynchronously.
There are no blocking operation or waiting for input, everything is directly
driven by the user/application feeding the DKIM object with data.

This module implements only DKIM according to RFC 6376.
It does not support the historic DomainKeys standard (RFC 4870).

The following methods are relevant.
For details of their use see the examples in the SYNOPSIS.

=over 4

=item new(%%args) -> $dkim

This will create a new object. The following arguments are supported

=over 8

=item dns => \%%hash

A hash with the DNS name as key and the DKIM record for this name as value.
This can be used as a common DNS cache shared over multiple instances of the
class. If none is given only a local hash will be created inside the object.

=item sign => \@dkim_sig

List of DKIM signatures which should be used for signing the mail (usually only
a single one). These can be given as string or hash (see `parse_signature'
below). These DKIM signatures are only used to collect the relevant information
from the header and body of the mail, the actual signing is done in the
SignRecord object (see below).

=item sign_and_verify => 0|1

Usually it either signs the mail (if `sign' is given) or validates signatures
inside the mail. When this option is true it will validate existing signatures
additionally to creating new signatures if `sign' is used.

=item filter => $sub

A filter function which gets applied to all signatures.
Signatures not matching the filter will be removed.
The function is called as `$sub->(\%%sig,$header)' where `%%sig' is the
signature hash and `$header' the header of the mail (which can be considered
the same over all calls of `$sub'). Typically this is used to exclude any
signature...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
