%define module_name Mail-POP3
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/PAM.pm) perl(Email/MIME.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(HTML/Entities.pm) perl(HTML/Form.pm) perl(HTML/FormatText.pm) perl(HTTP/Cookies.pm) perl(HTTP/Request/Common.pm) perl(IO/File.pm) perl(IO/Select.pm) perl(IO/Socket.pm) perl(LWP/UserAgent.pm) perl(Net/POP3.pm) perl(URI/URL.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.11
Release: alt1
Summary: - a module implementing a full POP3 server
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/E/ET/ETJ/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Mail::POP3' and its associated classes work together as follows:

the Mail::POP3::Daemon manpage does the socket-accepting.
the Mail::POP3::Server manpage does (most of) the network POP3 stuff.
the Mail::POP3::Security::User manpage and the Mail::POP3::Security::Connection manpage
do the checks on users and connections.
`Mail::POP3::Folder::*' classes handles the mail folders.

This last characteristic means that diverse sources of information
can be served up as though they are a POP3 mailbox by implementing
a `Mail::POP3::Folder' subclass. An example is provided in
the Mail::POP3::Folder::webscrape manpage, and included is a working configuration
file that makes the server connect to Jobserve (as of Jan 2014) and
provide a view of jobs as email messages in accordance with the username
which provides a colon-separated set of terms: keywords (encoding spaces
as `+'), location radius in miles, location (e.g. Berlin). E.g. the
username `perl:5:Berlin' would search for jobs relating to Perl within
5 miles of Berlin.

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build INSTALLMAN1DIR=%_man1dir

%install
%perl_vendor_install

%files
%doc README-v2.21 Changes TODO README.md
%perl_vendor_privlib/M*

%files scripts
%_man1dir/*
%_bindir/*

%changelog
