%define module_name Mail-SPF-Iterator
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Net/DNS.pm) perl(Socket6.pm) perl(URI.pm) perl(YAML.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.121
Release: alt1
Summary: iterative SPF lookup
Group: Development/Perl
License: perl
URL: https://github.com/noxxi/p5-mail-spf-iterator

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/S/SU/SULLR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides an iterative resolving of SPF records. Contrary to
Mail::SPF, which does blocking DNS lookups, this module just returns the DNS
queries and later expects the responses.

Lookup of the DNS records will be done outside of the module and can be done
in a event driven way.

This module can also make use of SenderID records for checking the `mfrom'
part, but only if it finds an SenderID record first (e.g. if the SPF reply
contains only SenderID and the the TXT SenderID and SPF and it gets the SPF
reply first it will use SenderID, if it gets TXT first it will use SPF).

This behavior is not compatible with RFC4406 where SenderID records take
preference, but compatible with RFC4408 in that it uses SPF records and
provides a way to use SenderID if no SPF records are given.

See RFC4408 for SPF and RFC4406 for SenderID.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes COPYRIGHT README
%perl_vendor_privlib/M*

%changelog
