# BEGIN SourceDeps(oneline):
BuildRequires: perl(DB_File.pm) perl(Email/Simple.pm) perl(ExtUtils/MakeMaker.pm) perl(Fcntl.pm) perl(Test/Deep.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_version 1.0.1
%define module_name Mail-ThreadKiller
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0.1
Release: alt1
Summary: get rid of an entire email thread
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/D/DS/DSKOLL/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module is meant to be used within an email filter such as
Email::Filter; specifically, it should be used in a filter that
is run by a delivery agent so it runs as the particular user whose mail
is being filtered---it is not suitable as a milter or any other type
of central filter.

Mail::ThreadKiller helps you discard or otherwise redirect entire
message threads.  The basic idea is as follows:

=over

=item *

You use whatever criteria you like to detect the *beginning* of an
email thread you'd like to kill.  Such criteria could include
the subject, the sender, the recipient list, etc.  For example,
a very common desire is to stop seeing all mail from a troublesome
mailing list poster as well as any replies to a thread started
by that poster.  In this case, your initial criterion could
be the troublesome poster's email address in the From: header.

=item *

Once you've detected the beginning of a thread, you *kill* the
message.  You use Mail::ThreadKiller to add the Message-ID to a
Berkeley database of IDs; we call this database the *persistent
database of killed threads* or the *kill database* for short.  Then
you configure your filter to dispose of the message however you like.

=item *

For all other messages, you ask Mail::ThreadKiller if any Message-IDs
in the `Message-ID:', `In-Reply-To:' or `References:' headers is in
the kill database.  If so, Mail::ThreadKiller adds the current
Message-ID to the database and returns true; you then dispose of the
message according to your policy.  If the message does not refer to
anything in the database, then Mail::ThreadKiller does nothing and
your filter continues processing normally.

=item *

Periodically, you run the script `threadkiller-clean-db.pl'
to remove very old Message-IDs from the kill database.

=back

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %{?epoch:%epoch:}%version-%release

%description scripts
scripts for %module_name
%prep
%setup -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
