Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(HTML/LinkExtor.pm) perl(LWP/UserAgent.pm) perl(Marpa/PP.pm) perl(Text/Diff.pm) perl(URI/URL.pm) perl(charnames.pm) perl-podlators
# END SourceDeps(oneline)
%filter_from_requires /^perl.Marpa.XS.Version.pm./d
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Marpa-XS
Version:        1.008000
Release:        alt13_40
Summary:        Language grammar parser module for Perl
License:        LGPL-3.0-or-later
URL:            https://metacpan.org/release/Marpa-XS
Source0:        https://cpan.metacpan.org/authors/id/J/JK/JKEGL/Marpa-XS-%{version}.tar.gz
Patch1:         0001-Require-2.124-Data-Dumper.patch
# Adjust to Perl 5.32, bug #1851334
Patch2:         Marpa-XS-1.008000-Adjust-to-Perl-5.32.patch
# Suppress the warnings about an intentionally used smartmatch operator
Patch3:         Marpa-XS-1.008000-Suppress-warnings-about-an-experimental-smartmatch-o.patch

BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-Glib-devel
BuildRequires:  perl-devel
BuildRequires:  perl
BuildRequires:  perl(ExtUtils/CBuilder.pm)
BuildRequires:  perl(Fatal.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(Glib/Install/Files.pm)
BuildRequires:  perl(IPC/Cmd.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(Module/Build.pm)
BuildRequires:  perl(Time/Piece.pm)
# Run-time
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(ExtUtils/PkgConfig.pm)
BuildRequires:  perl(Glib.pm)
# Bareword Glib::Log exported from Glib probably
BuildRequires:  perl(List/Util.pm)
BuildRequires:  perl(Scalar/Util.pm)
# Using ExtUtils::PkgConfig instead of perl(XSLoader)
BuildRequires:  pkgconfig(glib-2.0)
# Tests
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(YAML/XS.pm)
# Optional tests
BuildRequires:  perl(PPI.pm)
BuildRequires:  perl(PPI/Document.pm)
BuildRequires:  perl(Task/Weaken.pm)
# perl(Test::Weaken) >= 3.004000 not packaged yet
# AFAIK the PPI is used at test-time only. Do not require it?
Requires:       perl(PPI.pm) >= 1.206
Provides:       perl(Marpa/XS/Version.pm) = %{version}



# Remove under-specified dependencies


Source44: import.info
%filter_from_requires /^perl(Carp.pm)/d
%filter_from_provides /^perl(Marpa.XS.pm)/d
  

%description
Marpa::XS is a XS version of Marpa.

Marpa parses any language whose grammar can be written in BNF. That 
includes recursive grammars, ambiguous grammars, infinitely ambiguous 
grammars and grammars with useless or empty productions.


%prep
%setup -q -n Marpa-XS-%{version}
%patch1 -p1
%patch2 -p1
%patch3 -p1

# Update the various config.guess to upstream release for newer arch support
find ./ -name config.guess -exec cp /usr/lib/rpm/redhat/config.guess {} ';'
find ./ -name config.sub -exec cp /usr/lib/rpm/redhat/config.sub {} ';'

%build
# Switch to C89 mode because the implementation relies on implicit
# function declarations.
%global build_type_safety_c 0

CC="$CC -std=gnu89"
/usr/bin/perl Build.PL installdirs=vendor optimize="$RPM_OPT_FLAGS"
./Build


%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*


%check
./Build test


%files
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Marpa*
%doc --no-dereference COPYING COPYING.LESSER LICENSE
%doc Changes README


%changelog
