# BEGIN SourceDeps(oneline):
BuildRequires: perl(Capture/Tiny.pm) perl(Config.pm) perl(Config/Tiny.pm) perl(Date/Simple.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Copy.pm) perl(File/HomeDir.pm) perl(File/Slurper.pm) perl(File/Spec.pm) perl(Getopt/Long.pm) perl(GraphViz2.pm) perl(HTML/Entities/Interpolate.pm) perl(Log/Handler.pm) perl(Marpa/R2.pm) perl(Moo.pm) perl(Path/Tiny.pm) perl(Pod/Usage.pm) perl(Set/Array.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Text/CSV.pm) perl(Text/Xslate.pm) perl(Tree/DAG_Node.pm) perl(Try/Tiny.pm) perl(Types/Standard.pm) perl(charnames.pm) perl(open.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name MarpaX-Languages-Dash
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.00
Release: alt1
Summary: A Marpa-based parser for the DASH language
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RS/RSAVAGE/%{module_name}-%{version}.tgz
BuildArch: noarch

%description
This module implements a parser for the DASH entry elsewhere in this document (below), a wrapper language around Graphviz's
DOT. That is, the module is a pre-processor for the
DOT language.

Specifically, this module demonstrates how to use the Marpa::R2 manpage's capabilities to have Marpa
repeatedly pass control back to code in your own module, during the parse, to handle those cases
where you don't want Marpa's default processing to occur.

This allows the code to deal with the classic case of where you wish to preserve whitespace in some
contexts, but also want Marpa to discard whitespace in all other contexts.

DASH is easier to use than DOT, which means the user can specify graphs very simply, without having
to learn DOT.

The DASH language is actually a cut-down version of the language used by the Graph::Easy manpage. For a full
explanation of the Graph::Easy language, see http://bloodgate.com/perl/graph/manual/.

The wrapper is parsed into a tree of tokens managed by the Tree:DAG_Node manpage.

If requested by the user, the tree is passed to the default renderer
the MarpaX::Languages::Dash::Renderer manpage. Various options allow the user to control the output, as
an SVG (PNG, ...) image, and to save the DOT version of the graph.

In the past, the code in this module was part of Graph::Easy::Marpa, but that latter module has
been deleted from CPAN, and all it's new code and features, together with bug fixes, is in the
current module.

Note that this module's usage of Marpa's adverbs *event* and *pause* should be regarded as an
intermediate/advanced technique. For people just beginning to use Marpa, use of the *action* adverb
is the recommended technique.

The article mentioned above discusses important issues regarding the timing sequence of *pauses*
and *actions*.

All this assumes a relatively recent version of Marpa, one in which its Scanless interface (SLIF)
is implemented. I'm currently (2014-10-10) using the Marpa::R2 manpage V 2.096000.

Lastly, the parser and renderer will be incorporated ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changelog.ini README Changes
%perl_vendor_privlib/M*

%changelog
