# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Devel/LeakGuard/Object.pm) perl(Perl/Tidy.pm) perl(Test/Most.pm) perl(Test/Warn.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Mason
%define upstream_version 2.24

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Summary of differences between Mason 1 and
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module//%{upstream_name}-%{upstream_version}.tar.gz
Patch0:     Mason-2.15-missing_use.patch

BuildRequires: perl(Capture/Tiny.pm)
BuildRequires: perl(Class/Load.pm)
BuildRequires: perl(Class/Unload.pm)
BuildRequires: perl(Devel/GlobalDestruction.pm)
BuildRequires: perl(Exception/Class.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Guard.pm)
BuildRequires: perl(IPC/System/Simple.pm)
BuildRequires: perl(JSON.pm)
BuildRequires: perl(Log/Any.pm)
BuildRequires: perl(Memoize.pm)
BuildRequires: perl(Method/Signatures/Simple.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(MooseX/HasDefaults.pm)
BuildRequires: perl(MooseX/StrictConstructor.pm)
BuildRequires: perl(Scalar/Util.pm)
BuildRequires: perl(Test/Class/Most.pm)
BuildRequires: perl(Test/LongString.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildArch:  noarch
Source44: import.info

%description
Mason is a powerful Perl-based templating system, designed to generate
dynamic content of all kinds.

Unlike many templating systems, Mason does not attempt to invent an
alternate, "easier" syntax for templates. It provides a set of syntax and
features specific to template creation, but underneath it is still clearly
and proudly recognizable as Perl.

Mason is most often used for generating web pages. It can handle web
requests directly via PSGI, or act as the view layer for a web framework
such as Catalyst or Dancer.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}
%patch0 -p2


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes INSTALL LICENSE META.json META.yml  README eg
%{perl_vendor_privlib}/*
/usr/bin/mason.pl
%{_mandir}/man1/mason.pl.1*

%changelog
