%define module_name MasonX-Profiler
# BEGIN SourceDeps(oneline):
BuildRequires: perl(App/pod2pdf.pm) perl(CPAN.pm) perl(Capture/Tiny.pm) perl(ExtUtils/CBuilder.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Mason.pm) perl(IO/All.pm) perl(JSON.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Module/Signature.pm) perl(Net/FTP.pm) perl(Parse/CPAN/Meta.pm) perl(Pod/Markdown.pm) perl(Time/HiRes.pm) perl(YAML/Tiny.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Mason per-component profiler
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BP/BPS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module prints per-component profiling information to `STDERR'
(usually directed to the Apache error log).  Its output looks like this:

    =Mason= 127.0.0.1 - /NoAuth/webrt.css BEGINS {{{
    =Mason= 127.0.0.1 -     /NoAuth/webrt.css {{{
    =Mason= 127.0.0.1 -         /Elements/Callback {{{
    =Mason= 127.0.0.1 -         /Elements/Callback }}} 0.0008
    =Mason= 127.0.0.1 -     /NoAuth/webrt.css }}} 0.0072
    =Mason= 127.0.0.1 - /NoAuth/webrt.css }}} ENDS

Each row contains five whitespace-separated fields: `=Mason=', remote IP
address, `-', indented component name, and how many seconds did it take to
process that component, including all subcomponents called by it.

The beginning and end of the initial request is represented by the special
time fields `BEGINS' and `ENDS'.


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/M*

%changelog
